var XWiki = (function (XWiki) {
// Start XWiki augmentation.
Object.extend(XWiki, {
  userprofile : {
    init : function() {
      this.crtCategory = '';
      this.tabsContainer = $('vertical-tabs');
      if (!this.tabsContainer) {
        return;
      }
      this.tabsContainer.select('.vertical-tab').each(function (tabElement) {
        if (!tabElement.__name) {
          tabElement.__name = tabElement.id.replace(/Tab$/, '');
        }
        tabElement.observe('click', function(event) {
          Event.stop(event);
          this.switchTab(tabElement.__name);
        }.bindAsEventListener(this));
      }.bind(this));
      this.tabsContainer.select('.vertical-tab.active').each(function (activeTab) {
        this.updateCategoryFields(activeTab.__name);
        document.fire('xwiki:profile:switchedCategory', {'category' : activeTab.__name});
      }.bind(this));
      XWiki.userprofile.adjustTabsContainerHeight();
      this.handleCancelAction();
    },

    /*
    ** This ugly hack is used as a workaround for IE6 box model (3px jog bug) which prevent from 
    ** putting the  separating border between tabs and panes on the pane div. We put the border 
    ** on the tabs container and adjust its size depending on the size of the right pane.
    ** FIXME: find a better mechanism for tabbed UIs / drop this hack when stopping IE6 support.
    */
    adjustTabsContainerHeight: function() {
      var currentPane;
      $("vertical-panes").select("div.vertical-pane").each(function(pane){
        if(!pane.hasClassName('hidden')) {
          currentPane = pane;
        }
      });
      if (currentPane.getHeight() > $('vertical-tabs').getHeight()) {
        $('vertical-tabs').setStyle({ height: currentPane.getHeight() + 'px' });
      } else {
        $('vertical-tabs').setStyle({ height: '' });
      }
    },

    switchTab : function(tab) {
      $("vertical-panes").select("div.vertical-pane").each(function(pane){
        pane.addClassName('hidden');
      });
      $('vertical-tabs').setStyle({ height: '' });
      $(tab + 'Pane').removeClassName('hidden');
      $("vertical-tabs").select("li.vertical-tab").each(function(tab){
        tab.removeClassName('active');
      });
      $(tab + 'Tab').addClassName('active');
      XWiki.userprofile.adjustTabsContainerHeight();
      this.updateCategoryFields(tab);
      document.fire('xwiki:profile:switchedCategory', {'category' : tab});
    },

    updateCategoryFields : function (category) {
      this.crtCategory = category;
      this.updateField('xredirect', XWiki.currentDocument.getURL('view', 'category=' + category));
      this.updateField('xcontinue', XWiki.currentDocument.getURL('edit', 'editor=inline&category=' + category));
      this.updateField('category', category);
    },

    updateField : function (fieldName, value) {
      var element = $$('input[name=' + fieldName + ']');
      if (element && element.size() > 0) {
        element[0].value = value;
      }
    },

    handleCancelAction : function() {
      var elements = $$('form .buttons input[type=submit][name=action_cancel]');
      if (elements && elements.size() > 0) {
        var button = elements[0];
        Event.stopObserving(button, 'click');
        button.observe('click', function(event){
          event.stop();
          window.location = XWiki.currentDocument.getURL('view', 'category=' + this.crtCategory)
        }.bindAsEventListener(this));
      }
    }
  }
});

var init = function() {
  XWiki.userprofile.init();
  return true;
};
(XWiki.domIsLoaded && init()) || document.observe('xwiki:dom:loaded', init);
document.observe('lightbox:userprofile:loaded', init);
// End XWiki augmentation.
return XWiki;
}(XWiki || {}));
